/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tomcat;

import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.valves.ErrorReportValve;

public class HmcErrorReportValve
extends ErrorReportValve {
    private static final String TRACE_MASKT = "XTOMERVT";
    private static final String TRACE_MASKF = "XTOMERVF";
    private static final String TRACE_MASKD = "XTOMERVD";

    public HmcErrorReportValve() {
        Trace.trace(TRACE_MASKF, "<> HmcErrorReportValve.ctor()");
    }

    public void log(String msg) {
        Trace.trace(TRACE_MASKF, msg);
    }

    public void log(String msg, Throwable t) {
        Trace.trace(TRACE_MASKF, msg);
        Trace.trace(TRACE_MASKF, t);
    }

    public void report(Request request, Response response, Throwable throwable) throws IOException {
        Trace.trace(TRACE_MASKF, "-> HmcErrorReportValve.report");
        if (response instanceof HttpResponse && response instanceof HttpServletResponse) {
            HttpResponse hres = (HttpResponse)response;
            HttpServletResponse hsres = (HttpServletResponse)response;
            Trace.trace(TRACE_MASKF, "response status is: " + hres.getStatus());
            if (hres.getStatus() >= 400) {
                StringBuffer sb = new StringBuffer();
                Trace.trace(TRACE_MASKF, "building error response...");
                hsres.setContentType("text/html");
                PrintWriter out = hsres.getWriter();
                String msg = RequestUtil.filter((String)hres.getMessage());
                if (msg == null) {
                    msg = "";
                }
                sb.append("<html>");
                sb.append("<head>");
                sb.append("<title>Hardware Management Console Internal Error</title>");
                sb.append("</head>");
                sb.append("<body bgcolor=\"white\">");
                sb.append("<h1>Hardware Management Console Internal Error</h1><p>");
                sb.append(msg);
                sb.append("<br><hr size=\"1\" noshade><h2>Details:</h2><p><br>");
                sb.append("HTTP status code: ").append(hres.getStatus()).append("<p><br>");
                String report = null;
                try {
                    report = ErrorReportValve.sm.getString("http." + hres.getStatus(), (Object)msg);
                    if (report != null) {
                        sb.append(report);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                out.write(sb.toString());
                if (throwable != null) {
                    out.write("<p><br><pre>");
                    throwable.printStackTrace(out);
                    out.write("</pre>");
                    Throwable exc = throwable;
                    while (exc != null) {
                        if (exc instanceof ServletException) {
                            exc = ((ServletException)exc).getRootCause();
                        } else {
                            if (!(exc instanceof JspException)) break;
                            exc = ((JspException)exc).getRootCause();
                        }
                        if (exc == null) continue;
                        out.write("<p><br>Caused by:<br><pre>");
                        exc.printStackTrace(out);
                        out.write("</pre>");
                    }
                }
                out.write("<hr size=\"1\" noshade></body></html>");
            }
        } else {
            Trace.trace(TRACE_MASKF, "passing report onto super");
            super.report(request, response, throwable);
        }
        Trace.trace(TRACE_MASKF, "<- HmcErrorReportValve.report");
    }
}

